<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

// ✅ Corrigé : seulement deux niveaux à remonter
require_once __DIR__ . '/../../Config/config.php';
require_once __DIR__ . '/../../Core/Database.php';

header('Content-Type: application/json');
session_start();

// Reste du code identique
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method.']);
    exit;
}

$email = trim($_POST['email'] ?? '');
$password = trim($_POST['password'] ?? '');

if (empty($email) || empty($password)) {
    echo json_encode(['success' => false, 'message' => 'Email and password are required.']);
    exit;
}

try {
    $pdo = Database::db();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = ?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user'] = [
            'id' => $user['id'],
            'username' => $user['username'] ?? '',
            'display_name' => $user['display_name'] ?? '',
            'role' => $user['role'] ?? '',
            'email' => $user['email']
        ];
        echo json_encode(['success' => true, 'redirect' => BASE_URL . 'index.php']);
    } else {
        echo json_encode(['success' => false, 'message' => 'Invalid credentials.']);
    }
} catch (Throwable $e) {
    echo json_encode(['success' => false, 'message' => 'Database error: ' . $e->getMessage()]);
}
