<?php
if (session_status() === PHP_SESSION_NONE) session_start();
$user = $_SESSION['user'] ?? ['name' => 'Agent'];
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Tickets - CyberWall CallCenter</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.3/font/bootstrap-icons.css" rel="stylesheet">
  <style>
    body{background:#f8f9fa;font-family:"Segoe UI",sans-serif;}
    .sidebar{position:fixed;top:0;left:0;width:240px;height:100vh;background:#1f2d3a;color:#fff;}
    .sidebar .nav-link{color:#cfd8dc;padding:10px 20px;}
    .sidebar .nav-link.active,.sidebar .nav-link:hover{background:#273746;color:#fff;}
    .main{margin-left:240px;padding:2rem;}
  </style>
</head>
<body>
<div class="sidebar">
  <div class="p-3">
    <h4><i class="bi bi-telephone-fill me-2"></i>CyberWall</h4>
    <nav class="nav flex-column mt-4">
	<a class="nav-link <?= ($page ?? '') === 'dashboard' ? 'active' : '' ?>" href="index.php?page=dashboard">
  <i class="bi bi-speedometer2 me-2"></i> Dashboard
</a>
<a class="nav-link <?= ($page ?? '') === 'customers' ? 'active' : '' ?>" href="index.php?page=customers">
  <i class="bi bi-people me-2"></i> Customers
</a>
<a class="nav-link <?= ($page ?? '') === 'calls' ? 'active' : '' ?>" href="index.php?page=calls">
  <i class="bi bi-telephone me-2"></i> Calls
</a>
<a class="nav-link <?= ($page ?? '') === 'tickets' ? 'active' : '' ?>" href="index.php?page=tickets">
  <i class="bi bi-ticket-detailed me-2"></i> Tickets
</a>
<a class="nav-link <?= ($page ?? '') === 'reports' ? 'active' : '' ?>" href="index.php?page=reports">
  <i class="bi bi-bar-chart-line me-2"></i> Reports
</a>

    </nav>
  </div>
  <div class="p-3">
    <a href="login.php" class="nav-link text-danger"><i class="bi bi-box-arrow-right me-2"></i>Logout</a>
  </div>
</div>

<div class="main">
  <div class="d-flex justify-content-between mb-4">
    <h3 class="fw-bold">Support Tickets</h3>
    <span class="text-muted"><?= htmlspecialchars($user['name']) ?> | Agent</span>
  </div>

  <div class="card">
    <div class="card-header bg-warning text-dark"><i class="bi bi-ticket-detailed me-2"></i>Open Tickets</div>
    <div class="card-body">
      <table class="table table-striped">
        <thead><tr><th>ID</th><th>Subject</th><th>Customer</th><th>Priority</th><th>Status</th><th>Created</th></tr></thead>
        <tbody>
          <tr><td>#101</td><td>Broken AC unit</td><td>Aurora Housing</td><td>High</td><td>Open</td><td>2025-10-25</td></tr>
          <tr><td>#102</td><td>Network outage</td><td>Elmendorf AFB</td><td>Critical</td><td>In Progress</td><td>2025-10-24</td></tr>
          <tr><td>#103</td><td>Voicemail not syncing</td><td>Denali View</td><td>Normal</td><td>Resolved</td><td>2025-10-23</td></tr>
        </tbody>
      </table>
    </div>
  </div>
</div>
</body>
</html>
