<?php session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>CyberWall CallCenter - Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f1f4f8;font-family:"Segoe UI",sans-serif;}
.login-container{max-width:380px;margin:8% auto;padding:30px;background:white;border-radius:10px;box-shadow:0 0 15px rgba(0,0,0,0.1);}
</style>
</head>
<body>
<div class="login-container">
  <h4 class="text-center mb-4">🔐 CyberWall CallCenter</h4>
  <form id="loginForm">
    <div class="mb-3">
      <label>Email</label>
      <input type="email" name="email" class="form-control" required placeholder="agent1@cyberwallsec.com">
    </div>
    <div class="mb-3">
      <label>Password</label>
      <input type="password" name="password" class="form-control" required placeholder="password">
    </div>
    <button class="btn btn-primary w-100" type="submit">Login</button>
  </form>
  <div id="message" class="text-center mt-3 text-danger"></div>
</div>

<script>
document.querySelector('#loginForm').addEventListener('submit', async (e)=>{
  e.preventDefault();
  const formData = new FormData(e.target);
  const res = await fetch('http://localhost/callcenter2/app/Controllers/Api/AuthController.php', {
  method: 'POST',
  body: formData
});

  const data = await res.json();
  if(data.success){
    window.location.href = data.redirect;
  }else{
    document.getElementById('message').textContent = data.message;
  }
});
</script>
</body>
</html>
