<?php
require_once __DIR__ . '/../app/Config/config.php';
require_once __DIR__ . '/../app/Core/Database.php';

$pdo = Database::db();

$stats = [
  'agents' => $pdo->query("SELECT COUNT(*) AS c FROM users")->fetch()['c'] ?? 0,
  'active_agents' => $pdo->query("SELECT COUNT(*) AS c FROM agent_status WHERE status='available'")->fetch()['c'] ?? 0,
  'customers' => $pdo->query("SELECT COUNT(*) AS c FROM customers")->fetch()['c'] ?? 0,
  'tickets' => $pdo->query("SELECT COUNT(*) AS c FROM tickets WHERE status IN ('new','open','in_progress')")->fetch()['c'] ?? 0,
  'calls' => $pdo->query("SELECT COUNT(*) AS c FROM call_history")->fetch()['c'] ?? 0,
  'recent_calls' => []
];

$calls = $pdo->query("SELECT from_number, direction, status, duration, started_at FROM call_history ORDER BY started_at DESC LIMIT 5")->fetchAll();
foreach($calls as $c){
  $c['duration'] = gmdate('i:s', $c['duration'] ?? 0);
  $stats['recent_calls'][] = $c;
}

header('Content-Type: application/json');
echo json_encode($stats);
