<?php
require_once __DIR__ . '/../app/Config/config.php';
require_once __DIR__ . '/../app/Core/Database.php';
session_start();

$user = $_SESSION['user'] ?? null;
if (empty($user['id'])) {
  echo json_encode(['success'=>false,'message'=>'Not logged in']);
  exit;
}

$newStatus = $_POST['status'] ?? '';
$allowed = ['available','busy','break'];
if (!in_array($newStatus, $allowed)) {
  echo json_encode(['success'=>false,'message'=>'Invalid status']);
  exit;
}

$pdo = Database::db();
$stmt = $pdo->prepare("INSERT INTO agent_status (user_id, status, last_status_change)
VALUES (?, ?, NOW())
ON DUPLICATE KEY UPDATE status = VALUES(status), last_status_change = NOW()");
$stmt->execute([$user['id'], $newStatus]);

$map = [
  'available' => ['🟢','Online'],
  'busy'      => ['🔴','Busy'],
  'break'     => ['🟡','On Break'],
  'offline'   => ['⚫','Offline']
];
$badge = $map[$newStatus] ?? $map['offline'];

header('Content-Type: application/json');
echo json_encode(['success'=>true,'icon'=>$badge[0],'label'=>$badge[1]]);
